#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
using namespace std;

vector<int> possible_periods;
vector<int> primes = { 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449 };

void get_possible_periods(int n)
{
	for (int period : primes)
	{
		if (n % period == 0)
		{
			possible_periods.push_back(period);
		}

	}
}

void get_possible_periods_divisors(int n)
{
	int i;
	for (i = 1; i * i < n; i++)
	{
		if (n % i == 0)
		{
			possible_periods.push_back(i);
			possible_periods.push_back(n / i);
		}
	}
	if (i * i == n)
		possible_periods.push_back(i);
	sort(possible_periods.begin(), possible_periods.end());
}

void get_possible_periods_brute(int n)
{
	for (int i = 1; i <= n; i++)
		possible_periods.push_back(i);
}

int main()
{
	int n; cin >> n;
	get_possible_periods_divisors(n);
	int q; cin >> q;
	vector<long long> a(n);
	vector<long long> b(n);
	vector<set<vector<int>>> period_sets;
	cin >> a[0];
	for (int i = 1; i < n; i++)
	{
		cin >> a[i];
		b[i - 1] = a[i] ^ a[i - 1];
	}
	b[n - 1] = a[n - 1] ^ a[0];

	/*for (int period : possible_periods)
	{
		for (int j = 0; j < n; j += period)
		{
			vector<int> vec;
			for (int i = j; i < j + period; i++)
			{
				vec.push_back(b[i]);
			}
			period_sets[period].insert(vec);
		}
	}
	*/

	int smallest_period = -1;
	for (int period : possible_periods)
	{
		bool valid_period = true;
		vector<int> checking_vec;
		for (int i = 0; i < period; i++)
			checking_vec.push_back(b[i]);
		for (int i = period; i < n; i += period)
		{
			if (i + period > n) i = n - period;
			vector<int> vec;
			for (int j = i; j < i + period; j++)
			{
				vec.push_back(b[j]);
			}
			if (vec != checking_vec)
			{
				valid_period = false;
				break;
			}
		}
		if (valid_period)
		{
			smallest_period = period;
			break;
		}
	}

	cout << smallest_period << endl;

	while (q--)
	{
		int p, v; cin >> p >> v; p--;
		a[p] = v;
		if (p - 1 < 0)
		{
			b[n - 1] = a[n - 1] ^ a[0];
		}
		else
		{
			b[p - 1] = a[p - 1] ^ a[p];
		}
		if (p + 1 >= n)
		{
			b[n - 1] = a[n - 1] ^ a[0];
		}
		else
		{
			b[p] = a[p] ^ a[p + 1];
		}

		int smallest_period = -1;
		for (int period : possible_periods)
		{
			bool valid_period = true;
			vector<int> checking_vec;
			for (int i = 0; i < period; i++)
				checking_vec.push_back(b[i]);
			for (int i = period; i < n; i += period)
			{
				if (i + period > n) i = n - period;
				vector<int> vec;
				for (int j = i; j < i + period; j++)
				{
					vec.push_back(b[j]);
				}
				if (vec != checking_vec)
				{
					valid_period = false;
					break;
				}
			}
			if (valid_period)
			{
				smallest_period = period;
				break;
			}
		}

		cout << smallest_period << endl;


	}
}